/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * \file    ddr3.c
 *
 * \brief   Support routines for DDR test application
 *
 * This file contains the support function for DDR Test application.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "dm388_EVM.h"
#include "ddr3.h"

/*
 *====================
 * Function implementations
 *====================
 */
 
 /** **************************************************************************
 * \n \brief Routine to initialize ddr3
 *
 * 
 */

void ddr3_init(void)
{
	DM385_System_Initialisation_TEST_device();
}

/** **************************************************************************
 * \n \brief Routine to read from DDR3  memory
 * 
 * This routine reads from DDR3 memory.This routine takes buffer pointer as a 
 * parameter  from where data to be read along with that it contains buffer 
 * to copy read data and length of the buffer.
 *
 * \param   *pSrc  [IN]  buffer pointer to read data
 * \param   *pDSt  [IN]  buffer pointer to copy read data
 * \param   length [IN]  length of the buffer
 *
 */
 
void ddr3_read( UINT16 *pSrc, UINT16 *pDst, UINT32 length )
{
    while (length > 0)
    {
		if (1 == length)
		{
		    *pDst = *pSrc;
	    	length--;
		}
		else
		{
		    *pDst = *pSrc;
		    pSrc++; pDst++;
	    	length -= 2;
		}
    }
}
/** **************************************************************************
 * \n \brief Routine to write into ddr3
 *
 * This routine writes into ddr3.This routine takes pSrc buffer pointer as a 
 * parameter which contains data to be copied along with that pDst buffer 
 * pointer  which contains the address where to copy and lenght of the buffer
 *
 *
 * \param *pSrc   [IN]   buffer to be written into ddr3
 * \param *pDst   [IN]   address where data to be written
 * \param length  [IN]   length of the buffer
 *
 *  
 */

void ddr3_write( UINT16 *pSrc, UINT16 *pDst, UINT32 length )
{
    while (length > 0)
    {
		if (1 == length)
		{
		    *pDst = *pSrc;
		    length--;
		}
		else
		{
		    *pDst = *pSrc;
		    pSrc++;  pDst++;
	    	length -= 2;
		}
    }
}
